//Source file: H:\middleware\src\Alkindi\BusinessServices\Util\ProductData.java

package Alkindi.Services.InternalData;

/* 
$Header: PCRatDataByProd.java, 12, 4/26/01 2:36:57 PM, Schwartz, Joe$
$Log: 
 12   Alkindi Development1.11        4/26/01 2:36:57 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 11   Alkindi Development1.10        4/26/01 1:46:05 PM   Schwartz, Joe   Moved
      to new package.
 10   Alkindi Development1.9         12/28/00 1:07:26 PM  Schwartz, Joe   Added
      Version Control header info.
 9    Alkindi Development1.8         12/26/00 6:57:14 PM  Schwartz, Joe   
 8    Alkindi Development1.7         12/20/00 5:44:43 PM  Schwartz, Joe   
 7    Alkindi Development1.6         12/19/00 5:42:15 PM  Schwartz, Joe   
 6    Alkindi Development1.5         12/19/00 2:55:43 PM  Schwartz, Joe   
 5    Alkindi Development1.4         12/19/00 2:55:15 PM  Schwartz, Joe   Added
      calcWeigth functions.
 4    Alkindi Development1.3         12/18/00 6:08:54 PM  Schwartz, Joe   
 3    Alkindi Development1.2         12/18/00 3:57:37 PM  Schwartz, Joe   
 2    Alkindi Development1.1         12/18/00 3:57:27 PM  Schwartz, Joe   Moved
      from BeanImpl package; renaming class to ProductData.
 1    Alkindi Development1.0         11/8/00 3:00:20 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * 		Represents a row of data returned by the stored proc pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_USER
 */
public class PCRatDataByProd 
{
	public double n = 0;
	public double ei = 0;
	public double epi = 0;
	public double mi = 0;
	
	/**
	 * @roseuid 3A40D26A004E
	 */
	public final double E() 
	{
		return (ei -(epi/mi));
	}
	
	/**
	 * Calcuates the weight for the Product Cluster corresponding to the this ProductData object.
	 * @param K a tunable parameter
	 * @param B another tunable parameter
	 * @return double
	 * @roseuid 3A40D26A004F
	 */
	public final double calcWeight(final double K, final double B) 
	{
		double w = n*Math.exp(K+B*E());
		return w;
	}
}
